#!/bin/sh

MASTER_PAGE_SB_NUM_CONF_RESULT_MSG=""
MASTER_PAGE_SB_NUM_CONF_RESULT_OK=0
MASTER_PAGE_SB_NUM_CONF_RESULT_ERROR=1

MASTER_PAGE_SB_NUM_CONF_RESULT_CODE=${MASTER_PAGE_SB_NUM_CONF_RESULT_ERROR}
MASTER_PAGE_SB_NUM_CONF_RESULT_ROLLING=0


master_page_sb_num_conf() {
    debug_print "in function '${FUNCNAME[0]}'"

    local text=`printf \
            "${MASTER_PAGE_SB_NUM_CONF_TEXT}" \
            "24"`
            
    tp_inputbox \
        "${MASTER_PAGE_SB_NUM_CONF_TITLE}" \
        "${text}" \
        "${MASTER_PAGE_SB_NUM_CONF_OK_LABEL}" \
        "${MASTER_PAGE_SB_NUM_CONF_CANCEL_LABEL}" \
        "${RT_SB_NUMBER:-$conf_number_of_sb}"

    if [ "${TP_INPUTBOX_RESULT_CODE}" == "${TP_INPUTBOX_RESULT_CANCEL}" ]; then
        MASTER_PAGE_SB_NUM_CONF_RESULT_CODE=$MASTER_PAGE_SB_NUM_CONF_RESULT_OK
        MASTER_PAGE_SB_NUM_CONF_RESULT_ROLLING=-1
        MASTER_PAGE_SB_NUM_CONF_RESULT_MSG=""
        return
    fi

    local sb_number=`echo "${TP_INPUTBOX_RESULT_DATA}" | sed -n '1p'`
    debug_print "CheckUserDefinedSandboxNumber: UserDefinedSandboxNumber='${sb_number}'"
    
    # check 'SandboxNumber': started_with_zero
    echo "${sb_number}" | egrep -q '^[1-9][0-9]*$'
    local is_started_with_zero="${?}"
    
    # check 'SandboxNumber': positive and valid
    is_integer_positive_and_valid "${sb_number}"
    local is_positive_and_valid="${?}"
    
    if [ "${is_started_with_zero}"  -ne 0 ] || \
       [ "${is_positive_and_valid}" -ne 0 ] || \
       [ "${sb_number}" -gt 24 ] || \
       [ "${sb_number}" -lt 1 ]; then

        local text=`printf \
                "${MASTER_PAGE_SB_NUM_CONF_INVALID_NUM}" \
                "24"`

        debug_print "CheckUserDefinedSandboxNumberFail: UserDefinedSandboxNumber='${sb_number}'"
        debug_print "${text}"
        
        MASTER_PAGE_SB_NUM_CONF_RESULT_CODE=$MASTER_PAGE_SB_NUM_CONF_RESULT_ERROR
        MASTER_PAGE_SB_NUM_CONF_RESULT_ROLLING=0
        MASTER_PAGE_SB_NUM_CONF_RESULT_MSG="${text}"
        return
    fi
    debug_print "CheckUserDefinedSandboxNumberPass: UserDefinedSandboxNumber='${sb_number}'"
    
    RT_SB_NUMBER="${sb_number}"
    debug_print "RT_SB_NUMBER=${RT_SB_NUMBER}"
    
    MASTER_PAGE_SB_NUM_CONF_RESULT_CODE=$MASTER_PAGE_SB_NUM_CONF_RESULT_OK
    MASTER_PAGE_SB_NUM_CONF_RESULT_ROLLING=1
    MASTER_PAGE_SB_NUM_CONF_RESULT_MSG=""
}